/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorChainMutator;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.stalactite.mapping.EmbeddedClassMapping;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.stalactite.sql.result.MapBasedColumnedRow;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class EmbeddedClassMappingTest {
    private static Table targetTable;
    private static Column<Table, Integer> colA;
    private static Column<Table, Integer> colB;
    private static Column<Table, Integer> colC;
    private static Map<PropertyAccessor<Toto, Object>, Column<Table, Object>> classMapping;
    private EmbeddedClassMapping<Toto, ?> testInstance;

    EmbeddedClassMappingTest() {
    }

    @BeforeAll
    static void setUpClass() {
        targetTable = new Table("Toto");
        colA = targetTable.addColumn("a", Integer.class);
        colB = targetTable.addColumn("b", Integer.class);
        colC = targetTable.addColumn("c", Integer.class);
        classMapping = Maps.forHashMap((Class)null, (Class)null).add((Object)Accessors.propertyAccessor(Toto.class, (String)"a"), colA).add((Object)Accessors.propertyAccessor(Toto.class, (String)"b"), colB).add((Object)Accessors.propertyAccessor(Toto.class, (String)"c"), colC);
    }

    @BeforeEach
    void setUp() {
        this.testInstance = new EmbeddedClassMapping(Toto.class, targetTable, classMapping);
    }

    static Object[][] getInsertValues() {
        return new Object[][]{{new Toto(1, 2, 3), Maps.asMap(colA, (Object)1).add(colB, (Object)2).add(colC, (Object)3)}, {new Toto(null, null, null), Maps.asMap(colA, null).add(colB, null).add(colC, null)}, {new Toto(null, 2, 3), Maps.asMap(colA, null).add(colB, (Object)2).add(colC, (Object)3)}};
    }

    @ParameterizedTest
    @MethodSource
    void getInsertValues(Toto modified, Map<Column, Object> expectedResult) {
        Map valuesToInsert = this.testInstance.getInsertValues((Object)modified);
        Assertions.assertThat((Map)valuesToInsert).isEqualTo(expectedResult);
    }

    static Object[][] getUpdateValues_onlyNecessaryColumns() {
        return new Object[][]{{new Toto(1, 2, 3), new Toto(1, 5, 6), Maps.asMap(colB, (Object)2).add(colC, (Object)3)}, {new Toto(1, 2, 3), new Toto(1, null, null), Maps.asMap(colB, (Object)2).add(colC, (Object)3)}, {new Toto(1, 2, 3), new Toto(1, 2, 42), Maps.asMap(colC, (Object)3)}, {new Toto(1, 2, 3), new Toto(1, 23, 42), Maps.asMap(colB, (Object)2).add(colC, (Object)3)}, {new Toto(1, null, null), new Toto(1, 2, 3), Maps.asMap(colB, null).add(colC, null)}, {new Toto(null, null, null), new Toto(null, 2, 3), Maps.asMap(colB, null).add(colC, null)}, {new Toto(1, 2, 3), new Toto(1, 2, 3), new HashMap()}, {new Toto(null, null, null), new Toto(null, null, null), new HashMap()}, {new Toto(1, 2, 3), null, Maps.asMap(colA, (Object)1).add(colB, (Object)2).add(colC, (Object)3)}, {new Toto(null, 2, 3), null, Maps.asMap(colA, null).add(colB, (Object)2).add(colC, (Object)3)}, {new Toto(null, null, null), null, Maps.asMap(colA, null).add(colB, null).add(colC, null)}};
    }

    @ParameterizedTest
    @MethodSource
    <T extends Table<T>> void getUpdateValues_onlyNecessaryColumns(Toto modified, Toto unmodified, Map<Column<T, Object>, Object> expectedResult) {
        Map valuesToInsert = this.testInstance.getUpdateValues((Object)modified, (Object)unmodified, false);
        Assertions.assertThat((Map)Mapping.UpwhereColumn.getUpdateColumns((Map)valuesToInsert)).isEqualTo(expectedResult);
        Assertions.assertThat((Map)Mapping.UpwhereColumn.getWhereColumns((Map)valuesToInsert)).isEmpty();
    }

    static Object[][] getUpdateValues_allColumns() {
        return new Object[][]{{new Toto(1, 2, 3), new Toto(1, 2, 42), Maps.asMap(colA, (Object)1).add(colB, (Object)2).add(colC, (Object)3)}, {new Toto(null, null, null), new Toto(null, null, null), new HashMap()}, {new Toto(1, 2, 3), null, Maps.asMap(colA, (Object)1).add(colB, (Object)2).add(colC, (Object)3)}, {new Toto(1, 2, 3), new Toto(1, 2, 3), new HashMap()}};
    }

    @ParameterizedTest
    @MethodSource
    <T extends Table<T>> void getUpdateValues_allColumns(Toto modified, Toto unmodified, Map<Column, Object> expectedResult) {
        Map valuesToInsert = this.testInstance.getUpdateValues((Object)modified, (Object)unmodified, true);
        Assertions.assertThat((Map)Mapping.UpwhereColumn.getUpdateColumns((Map)valuesToInsert)).isEqualTo(expectedResult);
        Assertions.assertThat((Map)Mapping.UpwhereColumn.getWhereColumns((Map)valuesToInsert)).isEqualTo(new HashMap());
    }

    @Test
    <T extends Table<T>> void getUpdateValues_withModificationOnBeanAnNoModificationInShadowColumns() {
        final Column myShadowColumn = targetTable.addColumn("myShadowColumn", String.class);
        EmbeddedClassMapping testInstance = new EmbeddedClassMapping(Toto.class, targetTable, classMapping);
        Toto modified = new Toto(1, 2, 42);
        Toto unmodified = new Toto(1, 2, 3);
        testInstance.addShadowColumnUpdate(new Mapping.ShadowColumnValueProvider<Toto, T>(){

            public Set<Column<T, ?>> getColumns() {
                return Arrays.asSet((Object[])new Column[]{myShadowColumn});
            }

            public Map<Column<T, ?>, ?> giveValue(Toto bean) {
                return Maps.asMap((Object)myShadowColumn, (Object)"a");
            }
        });
        Maps.ChainingHashMap expectedResult = Maps.forHashMap(Column.class, Object.class).add(colA, (Object)1).add(colB, (Object)2).add(colC, (Object)42).add((Object)myShadowColumn, (Object)"a");
        Map valuesToUpdate = testInstance.getUpdateValues((Object)modified, (Object)unmodified, true);
        Assertions.assertThat((Map)Mapping.UpwhereColumn.getUpdateColumns((Map)valuesToUpdate)).isEqualTo((Object)expectedResult);
        Assertions.assertThat((Map)Mapping.UpwhereColumn.getWhereColumns((Map)valuesToUpdate)).isEqualTo(new HashMap());
    }

    @Test
    <T extends Table<T>> void getUpdateValues_withModificationOnBeanAnModificationInShadowColumns() {
        final Column myShadowColumn = targetTable.addColumn("myShadowColumn", String.class);
        EmbeddedClassMapping testInstance = new EmbeddedClassMapping(Toto.class, targetTable, classMapping);
        final Toto modified = new Toto(1, 2, 42);
        final Toto unmodified = new Toto(1, 2, 3);
        testInstance.addShadowColumnUpdate(new Mapping.ShadowColumnValueProvider<Toto, T>(){

            public Set<Column<T, ?>> getColumns() {
                return Arrays.asSet((Object[])new Column[]{myShadowColumn});
            }

            public Map<Column<T, ?>, ?> giveValue(Toto bean) {
                if (bean == modified) {
                    return Maps.asMap((Object)myShadowColumn, (Object)"b");
                }
                if (bean == unmodified) {
                    return Maps.asMap((Object)myShadowColumn, (Object)"a");
                }
                return null;
            }
        });
        Maps.ChainingHashMap expectedResult = Maps.forHashMap(Column.class, Object.class).add(colA, (Object)1).add(colB, (Object)2).add(colC, (Object)42).add((Object)myShadowColumn, (Object)"b");
        Map valuesToUpdate = testInstance.getUpdateValues((Object)modified, (Object)unmodified, true);
        Assertions.assertThat((Map)Mapping.UpwhereColumn.getUpdateColumns((Map)valuesToUpdate)).isEqualTo((Object)expectedResult);
        Assertions.assertThat((Map)Mapping.UpwhereColumn.getWhereColumns((Map)valuesToUpdate)).isEqualTo(new HashMap());
    }

    @Test
    <T extends Table<T>> void getUpdateValues_withNoModificationOnBeanAnModificationInShadowColumns() {
        final Column myShadowColumn = targetTable.addColumn("myShadowColumn", String.class);
        EmbeddedClassMapping testInstance = new EmbeddedClassMapping(Toto.class, targetTable, classMapping);
        final Toto modified = new Toto(1, 2, 3);
        final Toto unmodified = new Toto(1, 2, 3);
        testInstance.addShadowColumnUpdate(new Mapping.ShadowColumnValueProvider<Toto, T>(){

            public Set<Column<T, ?>> getColumns() {
                return Arrays.asSet((Object[])new Column[]{myShadowColumn});
            }

            public Map<Column<T, ?>, ?> giveValue(Toto bean) {
                if (bean == modified) {
                    return Maps.asMap((Object)myShadowColumn, (Object)"b");
                }
                if (bean == unmodified) {
                    return Maps.asMap((Object)myShadowColumn, (Object)"a");
                }
                return null;
            }
        });
        Maps.ChainingHashMap expectedResult = Maps.forHashMap(Column.class, Object.class).add(colA, (Object)1).add(colB, (Object)2).add(colC, (Object)3).add((Object)myShadowColumn, (Object)"b");
        Map valuesToUpdate = testInstance.getUpdateValues((Object)modified, (Object)unmodified, true);
        Assertions.assertThat((Map)Mapping.UpwhereColumn.getUpdateColumns((Map)valuesToUpdate)).isEqualTo((Object)expectedResult);
        Assertions.assertThat((Map)Mapping.UpwhereColumn.getWhereColumns((Map)valuesToUpdate)).isEqualTo(new HashMap());
    }

    @Test
    <T extends Table<T>> void getUpdateValues_withNoModificationOnBeanAnNoModificationInShadowColumns() {
        final Column myShadowColumn = targetTable.addColumn("myShadowColumn", String.class);
        EmbeddedClassMapping testInstance = new EmbeddedClassMapping(Toto.class, targetTable, classMapping);
        Toto modified = new Toto(1, 2, 3);
        Toto unmodified = new Toto(1, 2, 3);
        testInstance.addShadowColumnUpdate(new Mapping.ShadowColumnValueProvider<Toto, T>(){

            public Set<Column<T, ?>> getColumns() {
                return Arrays.asSet((Object[])new Column[]{myShadowColumn});
            }

            public Map<Column<T, ?>, ?> giveValue(Toto bean) {
                return Maps.asMap((Object)myShadowColumn, (Object)"a");
            }
        });
        Map valuesToUpdate = testInstance.getUpdateValues((Object)modified, (Object)unmodified, true);
        Assertions.assertThat((Map)Mapping.UpwhereColumn.getUpdateColumns((Map)valuesToUpdate)).isEmpty();
        Assertions.assertThat((Map)Mapping.UpwhereColumn.getWhereColumns((Map)valuesToUpdate)).isEmpty();
    }

    @Test
    void transform() {
        MapBasedColumnedRow row = new MapBasedColumnedRow();
        row.put((Selectable)targetTable.getColumn("a"), (Object)1);
        row.put((Selectable)targetTable.getColumn("b"), (Object)2);
        row.put((Selectable)targetTable.getColumn("c"), (Object)3);
        Toto toto = (Toto)this.testInstance.transform((ColumnedRow)row);
        Assertions.assertThat((int)toto.a).isEqualTo(1);
        Assertions.assertThat((int)toto.b).isEqualTo(2);
        Assertions.assertThat((int)toto.c).isEqualTo(3);
    }

    @Test
    void transform_withNullValueInRow_returnsNotNull() {
        MapBasedColumnedRow row = new MapBasedColumnedRow();
        row.put((Selectable)targetTable.getColumn("a"), null);
        row.put((Selectable)targetTable.getColumn("b"), null);
        row.put((Selectable)targetTable.getColumn("c"), null);
        EmbeddedClassMapping testInstance = new EmbeddedClassMapping(Toto.class, targetTable, classMapping);
        Toto toto = (Toto)testInstance.transform((ColumnedRow)row);
        Assertions.assertThat((Object)toto).isNotNull();
        Assertions.assertThat((Integer)toto.a).isNull();
        Assertions.assertThat((Integer)toto.b).isNull();
        Assertions.assertThat((Integer)toto.c).isNull();
    }

    @Test
    void defaultValueDeterminer() {
        EmbeddedClassMapping.DefaultValueDeterminer testInstance = new EmbeddedClassMapping.DefaultValueDeterminer(){};
        Assertions.assertThat((boolean)testInstance.isDefaultValue(new Duo(colA, (Object)Accessors.propertyAccessor(Toto.class, (String)"a")), null)).isTrue();
        Assertions.assertThat((boolean)testInstance.isDefaultValue(new Duo(colA, (Object)Accessors.propertyAccessor(ClassWithPrimitiveTypeProperties.class, (String)"x")), (Object)0)).isTrue();
        Assertions.assertThat((boolean)testInstance.isDefaultValue(new Duo(colA, (Object)Accessors.propertyAccessor(ClassWithPrimitiveTypeProperties.class, (String)"y")), (Object)false)).isTrue();
        Assertions.assertThat((boolean)testInstance.isDefaultValue(new Duo(colA, (Object)Accessors.mutatorByField(Toto.class, (String)"a")), null)).isTrue();
        Assertions.assertThat((boolean)testInstance.isDefaultValue(new Duo(colA, (Object)Accessors.mutatorByField(ClassWithPrimitiveTypeProperties.class, (String)"x")), (Object)0)).isTrue();
        Assertions.assertThat((boolean)testInstance.isDefaultValue(new Duo(colA, (Object)Accessors.mutatorByField(ClassWithPrimitiveTypeProperties.class, (String)"y")), (Object)false)).isTrue();
        Assertions.assertThat((boolean)testInstance.isDefaultValue(new Duo(colA, (Object)Accessors.mutatorByMethodReference(ClassWithPrimitiveTypeProperties::setX)), (Object)0)).isTrue();
        Assertions.assertThat((boolean)testInstance.isDefaultValue(new Duo(colA, (Object)Accessors.mutatorByMethodReference(ClassWithPrimitiveTypeProperties::setY)), (Object)false)).isTrue();
        Assertions.assertThat((boolean)testInstance.isDefaultValue(new Duo(colA, (Object)new AccessorChainMutator(Arrays.asList((Object[])new AccessorByMethodReference[]{Accessors.accessorByMethodReference(Object::toString)}), (Mutator)Accessors.mutatorByMethodReference(String::concat))), null)).isTrue();
        Assertions.assertThat((boolean)testInstance.isDefaultValue(new Duo(colA, (Object)Accessors.propertyAccessor(Toto.class, (String)"a")), (Object)42)).isFalse();
        Assertions.assertThat((boolean)testInstance.isDefaultValue(new Duo(colA, (Object)Accessors.propertyAccessor(ClassWithPrimitiveTypeProperties.class, (String)"x")), (Object)42)).isFalse();
        Assertions.assertThat((boolean)testInstance.isDefaultValue(new Duo(colA, (Object)Accessors.propertyAccessor(ClassWithPrimitiveTypeProperties.class, (String)"y")), (Object)true)).isFalse();
        Assertions.assertThat((boolean)testInstance.isDefaultValue(new Duo(colA, (Object)Accessors.mutatorByField(Toto.class, (String)"a")), (Object)42)).isFalse();
        Assertions.assertThat((boolean)testInstance.isDefaultValue(new Duo(colA, (Object)Accessors.mutatorByField(ClassWithPrimitiveTypeProperties.class, (String)"x")), (Object)42)).isFalse();
        Assertions.assertThat((boolean)testInstance.isDefaultValue(new Duo(colA, (Object)Accessors.mutatorByField(ClassWithPrimitiveTypeProperties.class, (String)"y")), (Object)true)).isFalse();
        Assertions.assertThat((boolean)testInstance.isDefaultValue(new Duo(colA, (Object)Accessors.mutatorByMethodReference(ClassWithPrimitiveTypeProperties::setX)), (Object)42)).isFalse();
        Assertions.assertThat((boolean)testInstance.isDefaultValue(new Duo(colA, (Object)Accessors.mutatorByMethodReference(ClassWithPrimitiveTypeProperties::setY)), (Object)true)).isFalse();
        Assertions.assertThat((boolean)testInstance.isDefaultValue(new Duo(colA, (Object)new AccessorChainMutator(Arrays.asList((Object[])new AccessorByMethodReference[]{Accessors.accessorByMethodReference(Object::toString)}), (Mutator)Accessors.mutatorByMethodReference(String::concat))), (Object)"")).isFalse();
    }

    @Test
    void constructor_columnFiltering() {
        Table targetTable = new Table("Toto");
        Column colA = targetTable.addColumn("a", Integer.class).primaryKey();
        Column colB = targetTable.addColumn("b", Integer.class).primaryKey().autoGenerated();
        Column colC = targetTable.addColumn("c", Integer.class);
        Maps.ChainingHashMap classMapping = Maps.forHashMap((Class)null, (Class)null).add((Object)Accessors.propertyAccessor(Toto.class, (String)"a"), (Object)colA).add((Object)Accessors.propertyAccessor(Toto.class, (String)"b"), (Object)colB).add((Object)Accessors.propertyAccessor(Toto.class, (String)"c"), (Object)colC);
        EmbeddedClassMapping testInstance = new EmbeddedClassMapping(Toto.class, targetTable, (Map)classMapping);
        Assertions.assertThat((boolean)testInstance.getInsertableColumns().contains(colA)).isTrue();
        Assertions.assertThat((boolean)testInstance.getUpdatableColumns().contains(colA)).isFalse();
        Assertions.assertThat((boolean)testInstance.getColumns().contains(colA)).isTrue();
        Assertions.assertThat((boolean)testInstance.getInsertableColumns().contains(colB)).isFalse();
        Assertions.assertThat((boolean)testInstance.getUpdatableColumns().contains(colB)).isFalse();
        Assertions.assertThat((boolean)testInstance.getColumns().contains(colB)).isTrue();
        Assertions.assertThat((boolean)testInstance.getInsertableColumns().contains(colC)).isTrue();
        Assertions.assertThat((boolean)testInstance.getUpdatableColumns().contains(colC)).isTrue();
        Assertions.assertThat((boolean)testInstance.getColumns().contains(colC)).isTrue();
    }

    private static class ClassWithPrimitiveTypeProperties {
        private int x;
        private boolean y;

        private ClassWithPrimitiveTypeProperties() {
        }

        public void setX(int x) {
            this.x = x;
        }

        public void setY(boolean y) {
            this.y = y;
        }
    }

    private static class Toto {
        private Integer a;
        private Integer b;
        private Integer c;

        public Toto() {
        }

        public Toto(Integer a, Integer b, Integer c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + Maps.asMap((Object)"a", (Object)this.a).add((Object)"b", (Object)this.b).add((Object)"c", (Object)this.c) + "]";
        }
    }
}

